require "prefabutil"

local chestfunctions = require "scenarios/chestfunctions"
local ImageButton = require "widgets/imagebutton"



local itemlist = {
	--cutgrass = "minotaur",
	butter = "butterfly",
	butterfly = "butterfly",
	butterflywings = "butterfly",
	honey = "bee",
	bee = "bee",
	stinger = "killerbee",
	killerbee = "killerbee",
	crow = "crow",
	feather_crow = "crow",
	robin = "robin",
	feather_robin = "robin",
	robin_winter = "robin_winter",
	feather_robin_winter = "robin_winter",
	drumstick = "perd",
	rabbit = "rabbit",
	mandrake = "mandrake",
	froglegs = "frog",
	beefalowool = "beefalo",
	horn = "beefalo",
	tentaclespike = "tentacle",
	tentaclespots = "tentacle",
	gears = "knight",
	bluegem = "icehound",
	houndstooth = "hound",
	pigskin = "pigguard",
	manrabbit_tail = "bunnyman",
	silk = "spider",
	spidergland = "spider",
	guano = "bat",
	batwing = "bat",
	slurper_pelt = "slurper",
	lightbulb = "slurper",
	wormlight = "worm",
	cave_banana = "monkey",
	minotaurhorn = "minotaur",
	lureplant_bulb = "lureplant",
	
	--DLC:
	coontail = "catcoon",
	mole = "mole",
	lightninggoathorn = "lightninggoat",
	
	--Bosses:
	deerclops_eyeball = "deerclops",
	livinglog = "leif",
	bearger_fur = "bearger",
	goose_feather = "moose",
	dragon_scales = "dragonfly",
}
local moblist = {
	butterfly_v = 3000,
	butterfly_n = "Butterfly",
	bee_v = 3000*2,
	bee_n = "Bee",
	killerbee_v = 3000*2,
	killerbee_n = "Killerbee",
	crow_v = 3000*5,
	crow_n = "Crow",
	robin_v = 3000*5,
	robin_n = "Robin",
	robin_winter_v = 3000*5,
	robin_winter_n = "Junco",
	perd_v = 3000*5,
	perd_n = "Gulugulu",
	rabbit_v = 3000*2,
	rabbit_n = "Rabbit",
	mandrake_v = 3000*20,
	mandrake_n = "Mandrake",
	frog_v = 3000*2,
	frog_n = "Frog",
	beefalo_v = 3000*5,
	beefalo_n = "Beefalo",
	tentacle_v = 3000*5,
	tentacle_n = "Tentacle",
	penguin_v = 3000*2,
	penguin_n = "Pengull",
	knight_v = 3000*15,
	knight_n = "Clockwork Knight",
	icehound_v = 3000*5,
	icehound_n = "Blue Doggy",
	hound_v = 3000,
	hound_n = "Doggy",
	pigguard_v = 3000*3,
	pigguard_n = "Guardian Steak",
	bunnyman_v = 3000*5,
	bunnyman_n = "Bunnyfriend",
	spider_v = 3000,
	spider_n = "Spider",
	bat_v = 3000*3,
	bat_n = "Batilisk",
	slurper_v = 3000*7.5,
	slurper_n = "Slurper",
	worm_v = 3000*15,
	worm_n = "Depth Worm",
	monkey_v = 3000*5,
	monkey_n = "Splumonkey",
	lureplant_v = 3000*12.5,
	lureplant_n = "Lureplant",
	
	--DLC:
	catcoon_v = 3000*5,
	catcoon_n = "Kitten",
	buzzard_v = 3000,
	buzzard_n = "Buzzard",
	mole_v = 3000*5,
	mole_n = "Moleworm",
	lightninggoat_v = 3000*10,
	lightninggoat_n = "Volt Goat",
	
	--bosses:
	deerclops_v = 3000*35,
	deerclops_n = "Deeclops -500",
	deerclops_h = 500,
	leif_v = 3000*25,
	leif_n = "Treeguard -300",
	leif_h = 300,
	bearger_v = 3000*50,
	bearger_n = "Bearger -600",
	bearger_h = 600,
	moose_v = 3000*40,
	moose_n = "Moose -750",
	moose_h = 750,
	dragonfly_v = 3000*50,
	dragonfly_n = "Dragonfly -500",
	dragonfly_h = 500,
	minotaur_v = 3000*30,
	minotaur_n = "Ancient Guardian -1000",
	minotaur_h = 1000,
	--decidoustree_v = 3000,
	--decidoustree_n = "Poison Birchnut Tree",
}
local timelist = {
	v0 = 0.25,
	n0 = "1/4 sec",
	v1 = 0.5,
	n1 = "1/2 sec",
	v2 = 1,
	n2 = "1 sec",
	v3 = 2,
	n3 = "2 sec",
	v4 = 3,
	n4 = "3 sec",
	v5 = 5,
	n5 = "5 sec",
	v6 = 10,
	n6 = "10 sec",
	v7 = 15,
	n7 = "15 sec",
	v8 = 20,
	n8 = "20 sec",
	v9 = 30,
	n9 = "1/2 min",
	v10 = 60,
	n10 = "1 min",
}


local assets=
{
	Asset("ANIM", "anim/mobexchanger.zip"),
	--Asset("ANIM", "anim/ui_chest_3x2.zip"),
	--Asset("ANIM", "anim/skull_chest.zip"),
	
	
	--   Asset("ANIM", "anim/ee_chest.zip"),
	
	Asset("IMAGE", "images/eechest.tex"),
	Asset("ATLAS", "images/eechest.xml"),
}

local function DoIdleFast(inst)
	inst.components.EMCglobalbuffer:AddFromGlobal(inst.components.EMCglobalbuffer.maxEMC/5.0)
end

local function DoIdle(inst)
	if EEmobexchangerNotAus == true then
		inst.idletask:Cancel()
		inst.idletask = nil
		inst.periodicSpawn = false
	else
		inst.spawnMob()
	end
end
local function StartIdling(inst)
	if not inst.idletask then
		inst.idletask = inst:DoPeriodicTask(timelist["v"..inst.periodicSpawnTime], DoIdle)
	end
end
local function StopIdling(inst)
	if inst.idletask then
		inst.idletask:Cancel()
		inst.idletask = nil
	end
end

local function onopen(inst)
	if EEmobexchangerNotAus == true then
		EEmobexchangerNotAus = false
	end
	StopIdling(inst)
	--inst.AnimState:PlayAnimation("open") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
	local doer = inst.components.container.opener
	if doer and doer.HUD and doer.HUD.controls.containers[inst] then
		inst.GUI = doer.HUD.controls.containers[inst]--.button
		local GUI = inst.GUI
		
		
		if not GUI.b1 then
			GUI.b1 = GUI:AddChild(ImageButton())
			function GUI.b1:SetMobname(name)
				if name then
					GUI.b1:SetText(name)
					GUI.b1.image:SetTint(0.5,1,0.5,1)
				else
					GUI.b1:SetText("nothing")
					GUI.b1.image:SetTint(1,0.5,0.5,1)
				end
			end
			GUI.b1:SetMobname(inst.targetName)
			GUI.b1:SetPosition(-125, 170, 0)
			GUI.b1:SetScale(1,1)
			GUI.b1:SetTextColour(0,0,0,1)
			GUI.b1:SetOnClick(function() inst:spawnMob() end)
			
			GUI.b2 = GUI:AddChild(ImageButton())
			GUI.b2:SetText("+")
			GUI.b2:SetPosition(-125, 80, 0)
			GUI.b2:SetScale(1,1)
			GUI.b2:SetTextColour(0,0,0,1)
			GUI.b2:SetOnClick(function() inst:PlusPeriodicSpawn(GUI) end)
			
			GUI.b3 = GUI:AddChild(ImageButton())
			function GUI.b3:SetColor(is)
				if is == true then
					GUI.b3.image:SetTint(0.5,1,0.5,1)
				else
					GUI.b3.image:SetTint(1,0.5,0.5,1)
				end
			end
			GUI.b3:SetColor(inst.periodicSpawn)
			GUI.b3:SetText(timelist["n"..inst.periodicSpawnTime])
			GUI.b3:SetPosition(-125, 15, 0)
			GUI.b3:SetScale(1,1)
			GUI.b3:SetTextColour(0,0,0,1)
			GUI.b3:SetOnClick(function() inst:togglePeriodicSpawn(GUI) end)
			
			GUI.b4 = GUI:AddChild(ImageButton())
			GUI.b4:SetText("-")
			GUI.b4:SetPosition(-125, -50, 0)
			GUI.b4:SetScale(1,1)
			GUI.b4:SetTextColour(0,0,0,1)
			GUI.b4:SetOnClick(function() inst:MinusPeriodicSpawn(GUI) end)
			
			GUI.b5 = GUI:AddChild(ImageButton())
			GUI.b5:SetText("set mob")
			GUI.b5:SetPosition(-125, -140, 0)
			GUI.b5:SetScale(1,1)
			GUI.b5:SetTextColour(0,0,0,1)
			GUI.b5:SetOnClick(function() inst:setMob(GUI) end)
		end

	end
	
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
end 

local function onclose(inst) 
	if inst.GUI then
		inst.GUI.b1:Hide()
		inst.GUI.b2:Hide()
		inst.GUI.b3:Hide()
		inst.GUI.b4:Hide()
		inst.GUI.b5:Hide()
	end
	
	if inst.periodicSpawn == true then
		StartIdling(inst)
	end

	--inst.AnimState:PlayAnimation("close") 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
	
	inst.components.workable:SetWorkAction(nil)
end 

local function onhammered(inst, worker)
	--inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	--inst.AnimState:PlayAnimation("hit")
	inst.components.container:DropEverything()
	--inst.AnimState:PushAnimation("closed", false)
	inst.components.container:Close()
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("idle",true)
	--inst.AnimState:PushAnimation("closed", false)
end

local slotpos = {}


table.insert(slotpos, Vector3(-125,-210,0))


local function OnSave(inst, data)
	if inst.targetMob and inst.targetName then
		data["targetMob"] = inst.targetMob
		data["targetName"] = inst.targetName
		inst.AnimState:PlayAnimation("open") 
		inst.AnimIsOpen = true
	end
	if inst.periodicSpawn == true then
		data["periodicSpawn"] = '1'
	end
	data["periodicSpawnTime"] = inst.periodicSpawnTime
end

local function OnLoad(inst, data)
	if not data then return end
	
	if data["targetMob"] and data["targetName"] then
		inst.targetMob = data["targetMob"]
		inst.targetName = data["targetName"]
	end
	if data["periodicSpawnTime"] then
		inst.periodicSpawnTime = data["periodicSpawnTime"]
	end
	if data["periodicSpawn"] then
		inst.periodicSpawn = true
		StartIdling(inst)
	else
		inst.periodicSpawn = false
	end
	
	if inst.targetMob then --seting the buffersize to the value of the mob
		inst.components.EMCglobalbuffer.maxEMC = moblist[inst.targetMob.."_v"]
	end
end

		
local function chest(style)
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		--local minimap = inst.entity:AddMiniMapEntity()
		
		--minimap:SetIcon( "birdcage.png" )


		inst:AddTag("structure")
		inst.AnimState:SetBank("mobexchanger")
		inst.AnimState:SetBuild("mobexchanger")
		--inst.AnimState:SetBuild("treasure_chest")
		inst.AnimState:PlayAnimation("idle")
		
		inst:AddComponent("inspectable")
		inst:AddComponent("container")
		inst.components.container:SetNumSlots(#slotpos)
		
		inst.components.container.onopenfn = onopen
		inst.components.container.onclosefn = onclose
		
		inst:AddComponent("EMCglobalbuffer")
		inst.components.EMCglobalbuffer.maxEMC = 0
		
		inst.components.container.widgetslotpos = slotpos
		inst.components.container.widgetanimbank = "ui_piggyback_2x6"
		inst.components.container.widgetanimbuild = "ui_piggyback_2x6"
		inst.components.container.widgetpos = Vector3(-120,200,0)
		inst.components.container.side_align_tip = 160
		
		--inst.targetMob = "mole"
		--inst.targetName = "Moleworm"
		function inst:spawnMob()
			if EEDEBUG == true then
				inst.components.EMCglobalbuffer:AddInt(inst.components.EMCglobalbuffer.maxEMC)
			end
			
			if inst.targetMob and inst.components.EMCglobalbuffer:GetBool(moblist[inst.targetMob.."_v"]) then
				local spawned = SpawnPrefab(inst.targetMob)
				local pt = Point(inst.Transform:GetWorldPosition())
				
				local distance = math.random()*5.0+3.0
				local angle = math.random()*2*math.pi
				pt.x = pt.x +distance*math.cos(angle)
				pt.z = pt.z +distance*math.sin(angle)

				local health = moblist[inst.targetMob.."_h"]
				if health then
					spawned.components.health.currenthealth = health
					spawned.EEmobexchanged = true
				end
				
				if inst.targetMob == "mole" then
					spawned:SetState("above")
					spawned.sg:GoToState("stunned", true)
				elseif inst.targetMob == "crow" or inst.targetMob == "robin" or inst.targetMob == "robin_winter" then
					--search for trap
					local pt2 = Point(inst.Transform:GetWorldPosition())
					local ents = TheSim:FindEntities(pt2.x,pt2.y,pt2.z, 8)
					for k, v in pairs(ents) do
						if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
							if v.prefab == "birdtrap" and v.components.trap.issprung == false then
								pt = Point(v.Transform:GetWorldPosition())
							end
						end
					end
				end
				
				spawned.Transform:SetPosition(pt.x, pt.y, pt.z)
				SpawnPrefab("collapse_small").Transform:SetPosition(pt.x, pt.y, pt.z)
			end
			
			
		end
		inst.AnimIsOpen = false
		function inst:setMob(GUI)
			inst.targetMob = nil
			inst.targetName = nil
			
			local item = inst.components.container:GetItemInSlot(1)
			if item then
				local mobprefab = itemlist[item.prefab]
				if mobprefab then
					inst.targetMob = mobprefab
					inst.targetName = moblist[mobprefab.."_n"]
				elseif item.prefab == "goldnugget" or item.prefab == "darkmatter" then
					SpawnPrefab("exchangerlever").Transform:SetPosition(inst.Transform:GetWorldPosition())
					SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
				else
					if item.EElastAttacked and moblist[item.EElastAttacked.."_n"] then
						inst.targetMob = item.EElastAttacked
						inst.targetName = moblist[item.EElastAttacked.."_n"]
					end
				end
			end
			
			if inst.targetMob then --seting the buffersize to the value of the mob
				inst.components.EMCglobalbuffer.maxEMC = moblist[inst.targetMob.."_v"]
			end
			
			GUI.b1:SetMobname(inst.targetName)
			if inst.targetName then
				if inst.AnimIsOpen == false then
					inst.AnimState:PlayAnimation("open") 
					inst.AnimIsOpen = true
				end
			else
				if inst.AnimIsOpen == true then
					inst.AnimIsOpen = false
					inst.AnimState:PlayAnimation("close")
				end
			end
		end
		inst.periodicSpawn = false
		inst.periodicSpawnTime = 2
		function inst:togglePeriodicSpawn(GUI)
			inst.periodicSpawn = not inst.periodicSpawn
			GUI.b3:SetColor(inst.periodicSpawn)
		end
		function inst:PlusPeriodicSpawn(GUI)
			if inst.periodicSpawnTime < 10 then
				inst.periodicSpawnTime = inst.periodicSpawnTime+1
				GUI.b3:SetText(timelist["n"..inst.periodicSpawnTime])
			end
		end
		function inst:MinusPeriodicSpawn(GUI)
			if inst.periodicSpawnTime > 0 then
				inst.periodicSpawnTime = inst.periodicSpawnTime-1
				GUI.b3:SetText(timelist["n"..inst.periodicSpawnTime])
			end
		end
		
		
		--inst:AddComponent("lootdropper")
		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(nil)
		inst.components.workable:SetWorkLeft(5)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 
		
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeSnowCovered(inst, .01)
		


		--inst:AddComponent("EMCglobalbuffer")
		--inst.components.EMCglobalbuffer.maxEMC = 0

		--StartIdling(inst)
		
		
		
		inst.OnSave = OnSave
		inst.OnLoad = OnLoad
		
		inst.idletaskFast = inst:DoPeriodicTask(.05, DoIdleFast)
		
		return inst
	end
	return fn
end



return	Prefab( "common/prefab/mobexchanger", chest("ee_chest"), assets),
		MakePlacer("common/prefab/mobexchanger_placer", "mobexchanger", "mobexchanger", "idle")

